#include <rnd/Max.c>

typedef struct
{
	V2 (*B)(const V2); // Goal field function
	REAL gfr; // Good field radius e.g. 10e-3
	REAL *(*coil)(const REAL r,const int pm);
} GoalField;

REAL rmserror(const Magnet mag,const GoalField goal)
{
	V2 p,B; REAL tt=0; int denom=0; p.y=0;
	for (p.x=-goal.gfr;p.x<=goal.gfr;p.x+=0.1e-3)
	//for (REAL th=0;th<359;th+=2)
	{
		//p=gfr*V2_degs(th);
		B=Magnet_field(mag,p)-goal.B(p);
		tt+=V2_normsq(B); denom++;
	}
	return sqrt(tt/denom);
}

REAL maxerror(const Magnet mag,const GoalField goal)
{
	V2 p,B; REAL ret=0; p.y=0;
	for (p.x=-goal.gfr;p.x<=goal.gfr;p.x+=0.1e-3)
	{
		B=Magnet_field(mag,p)-goal.B(p);
		ret=Max(ret,V2_norm(B));
	}
	return ret;
}

REAL rmserrorcoil(const Magnet mag,const GoalField goal,const V2 c=V2_zero,const int pm=15)
{
	REAL *f=Magnet_rotatingcoil_interleaved(mag,c,goal.gfr,pm),*g=goal.coil(goal.gfr,pm),ret=0;
	for (int n=array_1d_m(f)-1;n>=0;n--) ret+=sq(f[n]-g[n]);
	array_1d_free(f); array_1d_free(g);
	return sqrt(ret);
}
