#include "magnet.c"
#include "goalfield.c"
#include "optimise.c"
#include <rnd/frnd.c>

REAL goal_dipole=0,goal_quad=0;

V2 goalfield(const V2 p)
{
	return V2_new(0,goal_dipole)+goal_quad*V2_new(p.y,p.x); 
}

REAL *goalfield_coil(const REAL r,const int pm)
{
	REAL *ret=array_1d_zeroed(pm*2);
	ret[0]=goal_dipole; ret[1]=0; ret[2]=goal_quad*r; // Linear field magnet
	return ret;
}

GoalField goal_new(const REAL dip,const REAL quad,const REAL gfr)
{
	GoalField ret;
	goal_dipole=dip; goal_quad=quad;
	ret.B=goalfield; ret.coil=goalfield_coil;
	ret.gfr=gfr;
	return ret;
}

#include "makemagnet_cbeta.c"

REAL R_inner=0,Br1=1.07;

Magnet makemagnet_param(const REAL *a)
{
	return makemagnet_cbeta(a,R_inner,Br1,2,1);
	//Magnet_IronWires_init(&ret,IronWires_feedback);
}

void params_reset(REAL *a)
{
	for (int n=array_1d_m(a)-1;n>=0;n--) a[n]=frnd(0.01)-0.005;
}

#include <stdio.h>
#include <rnd/explode.c>

int main(int argc,const char *argv[])
{
	if (argc<=1) magnet_error("Usage:\nhalbacharea R=30e-3 dipole=0.2 quad=30\n");
	int n,i; REAL dipole=0,quad=0;
	for (n=1;n<argc;n++)
	{
		char **e=explode("=",argv[n]);
		if (!strcmpi(e[0],"R")) R_inner=atof(e[1]);
		else if (!strcmpi(e[0],"dipole")) dipole=atof(e[1]);
		else if (!strcmpi(e[0],"quad")) quad=atof(e[1]);
		else if (!strcmpi(e[0],"Br")) Br1=atof(e[1]);
		explodefree(e);
	}
	if (R_inner==0) magnet_error("No inner radius specified.");
	REAL ethresh=1e-5*Max(fabs(dipole),fabs(R_inner*quad));
	REAL *a=array_1d(16);
	params_reset(a);
	GoalField goal=goal_new(dipole,quad,R_inner*2.0/3);
	int pm=15;
	REAL *pn=array_1d(pm),*ps=array_1d(pm),emax;
	Magnet mag;
	for (n=0;n<15;n++)
	{
		param_optimise_svd(makemagnet_param,a,goal);
		mag=makemagnet_param(a);
		Magnet_rotatingcoil(mag,V2_zero,goal.gfr,pn,ps);
		emax=0;
		pn[0]-=dipole; pn[1]-=quad*goal.gfr;
		for (i=pm-1;i>=0;i--) emax=Max(emax,Max(fabs(pn[i]),fabs(ps[i])));
		Magnet_free(mag);
		printf("Iteration %d, error=%lg T\n",1+n,emax);
		if (emax<=ethresh) break;
	}	
	array_1d_free(pn); array_1d_free(ps);
	if (emax>ethresh*10) magnet_error("Not converged");
	mag=makemagnet_param(a);
	printf("Area=%lg cm^2\nMax radius=%lg cm",Magnet_area(mag)/1e-4,Magnet_maxr(mag)/1e-2);
	Magnet_save(mag,"magnet.csv");
	Magnet_free(mag);
}
