#ifndef SBCLIB_CSV
// Sort-of-minimal CSV format library [Stephen Brooks 2013]
// Utilises LSet and "explodesegs" etc.
#include <stdio.h>
#include <lset.c>
#include <rnd/explode.c>
#include <rnd/fgetline.c>

typedef char ***csv;

#define csvm(C) (((unsigned *)(C))[-1])
#define csvrowm(R) (((unsigned *)(R))[-1])

csv csvload(const char *filename,const char *sep=",")
{
	FILE *in=fopen(filename,"rb");
	if (!in) return NULL;
	LSet rs=LSet(char **);
	for (char *s,**e;s=fgetline(in);free(s))
	{
		e=explode(sep,s);
		LSet_add(&rs,&e);
	}
	fclose(in);
	char ***ret=(char ***)malloc(sizeof(unsigned)+rs.m*sizeof(char **));
	*(unsigned *)ret=rs.m;
	memcpy((unsigned char *)ret+sizeof(unsigned),rs.a,rs.m*sizeof(char **));
	LSet_free(rs);
	return (csv)((unsigned char *)ret+sizeof(unsigned));
}

void csvfree(csv c)
{
	for (int n=csvm(c)-1;n>=0;n--) explodefree(c[n]);
	free((unsigned char *)c-sizeof(unsigned));
}

void csvdeleteheaderrow(csv c)
{
	int n,m=csvm(c);
	for (n=0;n+1<m;n++) c[n]=c[n+1];
	csvm(c)--;
}

#define SBCLIB_CSV
#endif
