#ifndef SBCLIB_RND_explode
// These three functions are "closely coupled" - none can really legitimately be used without the others
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <rnd/strcseg.c>
char **explode(const char *split,const char *str)
{
	int m=1,splen=strlen(split); const char *s;
	for (s=str;*s;s++) if (strcseg(s,split)) {m++; s+=splen-1;}
	char **ret=(char **)malloc((m+1)*sizeof(char *));
	ret++; ((int *)ret)[-1]=m;
	int n=0,i=0,len;
	for (s=str;*s;s++) if (strcseg(s,split))
	{
		len=s-str-i;
		ret[n]=(char *)malloc(len+1);
		memcpy(ret[n],str+i,len); ret[n][len]=0;
		n++; s+=splen; i=s-str; s--;
	}
	len=s-str-i;
	ret[n]=(char *)malloc(len+1);
	memcpy(ret[n],str+i,len); ret[n][len]=0;
	return ret;
}

char **explodews(const char *str)
{ // Explodes by blocks of whitespace (spaces, tabs etc.)
	int n,i,m,len; const char *s,*t;
	for (s=str,i=1,m=0;*s;s++) if ((!!isspace(*s))!=i) // On gcc, isspace(' ')==8 not 1...
		{if (i) m++; i^=1;}
	char **ret=(char **)malloc((m+1)*sizeof(char *));
	ret++; ((int *)ret)[-1]=m;
	for (s=str,i=1,n=0;*s;s++) if ((!!isspace(*s))!=i)
	{
		if (i) t=s;
		i^=1;
		if (i)
		{
			len=s-t;
			ret[n]=(char *)malloc(len+1);
			memcpy(ret[n],t,len); ret[n][len]=0;
			n++;
		}
	}
	if (!i)
	{
		len=s-t;
		ret[n]=(char *)malloc(len+1);
		memcpy(ret[n],t,len); ret[n][len]=0;
	}
	return ret;
}

int explodesegs(const char * const *ex)
{
	return (int)((const int *)ex)[-1];
}

void explodefree(char **ex)
{
	for (int n=explodesegs(ex)-1;n>=0;n--) free(ex[n]);
	free(ex-1);
}

void explodefreeshallow(char **ex)
{
	free(ex-1);
}
#define SBCLIB_RND_explode
#endif
