#ifndef SBCLIB_RND_fgetline
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *fgetline(FILE *in)
{ // String constructor, reads a line from a file (returning NULL if EOF) - USE BINARY MODE!!
	char *ret; int l,ch; long p=ftell(in);
	for (l=0;ch=fgetc(in), ch!=EOF && ch && ch!=0x0A && ch!=0x0D;l++);
	ret=(char *)malloc(l+1);
	if (l) do {fseek(in,p,SEEK_SET); ch=fread(ret,1,l,in);} while (ch!=l);
	else fseek(in,p,SEEK_SET);
	ret[l]=0;
	if (fgetc(in)==0x0D) // Go past terminating character
	{ // If it is \r, look for a matching \n
		ch=fgetc(in); if (ch!=0x0A && ch!=EOF) fseek(in,-1,SEEK_CUR);
	}
	if (l==0 && feof(in)) {free(ret); return NULL;}
	return ret;
} 

/* // Example usage:
	FILE *in=fopen(filename,"rb");
	for (char *l;l=fgetline(in);free(l))
	{
		// Do something with l
	}
	fclose(in);
*/

// NB: since this calls fgetc repeatedly, it is less efficient than filedata or filestring,sgetline
#define SBCLIB_RND_fgetline
#endif
