Magnet makemagnet_cbeta(const REAL *a,const REAL R,const REAL Br,const int wedges=1,const int symm=0,const REAL asp=1)
{ // Set R=0.0285 (physical inner edge of poles) for QF; gfr=19mm
	// Set R=0.022 for BD; gfr=12.5mm
	Magnet ret=Magnet_new();
	if (array_1d_m(a)%2) magnet_error("Odd number of parameters given to makemagnets_cbeta");
	int n,sides=symm?array_1d_m(a):array_1d_m(a)/2;
	REAL th=M_TWOPI/sides,hth=0.5*th,hw=R*tan(hth),dr,dr2; Poly p; V2 v,v2;
REAL vgap=0.01; vgap=0;
	for (n=symm?sides/2-(wedges==2):sides-1;n>=0;n--)
	{
		if (wedges>=3)
		{
			int h=n,i=(n-1+sides)%sides;
			if (symm) {if (i==sides-1) i=0; if (h==sides/2) h=sides/2-1;}
			v=V2_new(a[h*2],a[h*2+1]);
			v2=V2_new(a[i*2],a[i*2+1]);
		}
		else v=v2=V2_new(a[n*2],a[n*2+1]);
		dr=0.2*sq(sin(sqrt(V2_norm(v)))); dr2=0.2*sq(sin(sqrt(V2_norm(v2))));
//sprintf(str,"dr[%d] = %lg m",n,dr); bfwrite(xres/4,n*BF_height,str,GFX_white);
		p=Poly_new();
		Poly_addpoint(&p,R,hw);
		REAL hf=hw,hf2=hw;
		if (wedges) {hf*=(R+dr)/R; hf2*=(R+dr2)/R;}
		Poly_addpoint(&p,R+dr,hf);
		Poly_addpoint(&p,R+dr2,-hf2);
		Poly_addpoint(&p,R,-hw);
		Poly_rotate(&p,(n+0.5*(wedges==2 || wedges==4))*th);
		Poly_scalex(&p,asp);
		//V2 *pv=(V2 *)p.vs.a; pv[0].x*=asp; pv[3].x*=asp; pv[1]*=asp; pv[2]*=asp; // It's not a line if you don't do the same thing to both ends
		Poly_avoidvgap(&p,vgap);
		if (wedges>=3) p.Br=Br*V2_normalise(v+v2);
		else p.Br=Br*V2_normalise(v);
		LSet_add(&ret.polys,&p);
		if (symm && (n>0 || wedges==2) && n<sides/2)
		{
			Poly q=Poly_copy(p);
			Poly_flipy(&q);
			q.Br.x*=-1;
			LSet_add(&ret.polys,&q);
		}
	}
	return ret;
}
