#include <svd.c>
#include <rnd/cu.c>

REAL **rotatingcoil_param_response(Magnet (* const Magnet_fromparams)(const REAL *),
	const REAL *a,const V2 c,const REAL r,const int pm=15,REAL **po=NULL)
{
	const REAL eps=1e-6;
	Magnet mag=Magnet_fromparams(a);
	REAL *o=Magnet_rotatingcoil_interleaved(mag,c,r,pm);
	Magnet_free(mag);
	int n,i,m=array_1d_m(a); REAL *b=array_1d_copy(a),*x;
	REAL **ret=array_2d(pm*2,m);
	for (n=m-1;n>=0;n--)
	{
		b[n]+=eps;
		mag=Magnet_fromparams(b);
		x=Magnet_rotatingcoil_interleaved(mag,c,r,pm);
		Magnet_free(mag);
		for (i=pm*2-1;i>=0;i--) ret[i][n]=(x[i]-o[i])/eps;
		array_1d_free(x);
		b[n]=a[n];
	}
	array_1d_free(b);
	if (po) *po=o; else array_1d_free(o);
	return ret;
}

REAL lambda_svd=1;

void param_optimise_svd(Magnet (* const Magnet_fromparams)(const REAL *),
	REAL *a,const GoalField goal)
{
	int n,i,m=array_1d_m(a),pm=17; V2 coilc=V2_zero;
	Magnet mag=Magnet_fromparams(a);
	REAL *b=array_1d_copy(a),step,eref=rmserrorcoil(mag,goal,coilc);
	Magnet_free(mag);
	REAL *f,*g=goal.coil(goal.gfr,pm),**rm=rotatingcoil_param_response(Magnet_fromparams,a,coilc,goal.gfr,pm,&f);
	//array_2d_plot(0,yres/2,5,rm,colmap2);
	array_1d_sub(f,g); array_1d_free(g); // Errors
	REAL **u,**v,*s=svd(rm,&u,&v),bl=-1,*c,e,be=eref;
	array_2d_free(rm);
	for (n=-10;n<=10;n++)
	{
		REAL l=lambda_svd*pow(1e4,cu(0.1*n));
		c=svdsolve_inner(s,u,v,f,l);
	   	for (i=m-1;i>=0;i--) b[i]=a[i]-c[i];
	   	array_1d_free(c);
		mag=Magnet_fromparams(b);	   	
   		e=rmserrorcoil(mag,goal,coilc);
   		Magnet_free(mag);
   		if (e<be) {be=e; bl=l;}
	}
	array_1d_free(b);
	c=svdsolve_inner(s,u,v,f,bl);
	svdfree(s,u,v); array_1d_free(f);
	if (be<eref) for (n=m-1;n>=0;n--) {a[n]-=c[n]; lambda_svd=bl;}
   	array_1d_free(c); 
	if (0)
	{
	   	FILE *out=fopen("param_optimise_svd.csv","at");
		fprintf(out,"%.15lg,%.15lg,%.9lg,",eref,be,bl);
		array_1d_printwrite(a,out,"%.9lg",",");
	   	fclose(out);
	}
}

REAL lambda_steepest=1;

void param_optimise_steepest(Magnet (* const Magnet_fromparams)(const REAL *),
	REAL *a,const GoalField goal)
{
	int n,i,m=array_1d_m(a),pm=17; V2 coilc=V2_zero; 
	Magnet mag=Magnet_fromparams(a);
	REAL *b=array_1d_copy(a),step,eref=rmserrorcoil(mag,goal,coilc);
	Magnet_free(mag);
	REAL *f,*g=goal.coil(goal.gfr,pm),**rm=rotatingcoil_param_response(Magnet_fromparams,a,coilc,goal.gfr,pm,&f);
	array_1d_sub(f,g); array_1d_free(g); // Errors
	REAL *u=matrixtmulvector(rm,f);
	array_1d_free(f);
	REAL bl=-1,e,be=eref;
	array_2d_free(rm);
	for (n=-10;n<=10;n++)
	{
		REAL l=lambda_steepest*pow(1e6,cu(0.1*n));
	   	for (i=m-1;i>=0;i--) b[i]=a[i]-l*u[i];
		mag=Magnet_fromparams(b);
   		e=rmserrorcoil(mag,goal,coilc);
   		Magnet_free(mag);
   		if (e<be) {be=e; bl=l;}
	}
	array_1d_free(b);
	if (be<eref) for (n=m-1;n>=0;n--) {a[n]-=bl*u[n]; lambda_steepest=bl;}
	array_1d_free(u); 
	if (0)
	{
	   	FILE *out=fopen("param_optimise_steepest.csv","at");
		fprintf(out,"%.15lg,%.15lg,%.9lg,",eref,be,bl);
		array_1d_printwrite(a,out,"%.9lg",",");
	   	fclose(out);
	}
}
